<?php
class installerCfs {
	static public $update_to_version_method = '';
	static private $_firstTimeActivated = false;
	static public function init( $isUpdate = false ) {
		global $wpdb;
		$wpPrefix = $wpdb->prefix; /* add to 0.0.3 Versiom */
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		$current_version = get_option($wpPrefix. CFS_DB_PREF. 'db_version', 0);
		if(!$current_version)
			self::$_firstTimeActivated = true;
		/**
		 * modules 
		 */
		if (!dbCfs::exist("@__modules")) {
			dbDelta(dbCfs::prepareQuery("CREATE TABLE IF NOT EXISTS `@__modules` (
			  `id` smallint(3) NOT NULL AUTO_INCREMENT,
			  `code` varchar(32) NOT NULL,
			  `active` tinyint(1) NOT NULL DEFAULT '0',
			  `type_id` tinyint(1) NOT NULL DEFAULT '0',
			  `label` varchar(64) DEFAULT NULL,
			  `ex_plug_dir` varchar(255) DEFAULT NULL,
			  PRIMARY KEY (`id`),
			  UNIQUE INDEX `code` (`code`)
			) DEFAULT CHARSET=utf8;"));
			dbCfs::query("INSERT INTO `@__modules` (id, code, active, type_id, label) VALUES
				(NULL, 'adminmenu',1,1,'Admin Menu'),
				(NULL, 'options',1,1,'Options'),
				(NULL, 'user',1,1,'Users'),
				(NULL, 'pages',1,1,'Pages'),
				(NULL, 'templates',1,1,'templates'),
				(NULL, 'supsystic_promo',1,1,'supsystic_promo'),
				(NULL, 'admin_nav',1,1,'admin_nav'),
				
				(NULL, 'forms',1,1,'forms'),
				(NULL, 'forms_widget',1,1,'forms_widget'),

				(NULL, 'statistics',1,1,'statistics'),
				
				(NULL, 'mail',1,1,'mail');");
		}
		/**
		 *  modules_type 
		 */
		if(!dbCfs::exist("@__modules_type")) {
			dbDelta(dbCfs::prepareQuery("CREATE TABLE IF NOT EXISTS `@__modules_type` (
			  `id` smallint(3) NOT NULL AUTO_INCREMENT,
			  `label` varchar(32) NOT NULL,
			  PRIMARY KEY (`id`)
			) AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;"));
			dbCfs::query("INSERT INTO `@__modules_type` VALUES
				(1,'system'),
				(6,'addons');");
		}
		/**
		 * Form table
		 */
		if (!dbCfs::exist("@__forms")) {
			dbDelta(dbCfs::prepareQuery("CREATE TABLE IF NOT EXISTS `@__forms` (
				`id` INT(11) NOT NULL AUTO_INCREMENT,
				`label` VARCHAR(255) NOT NULL,
				`active` TINYINT(1) NOT NULL DEFAULT '1',
				`original_id` INT(11) NOT NULL DEFAULT '0',
				`unique_id` VARCHAR(8) NOT NULL,
				
				`params` TEXT NOT NULL,
				`html` TEXT NOT NULL,
				`css` TEXT NOT NULL,
				`img_preview` VARCHAR(128) NULL DEFAULT NULL,
				
				`views` INT(11) NOT NULL DEFAULT '0',
				`unique_views` INT(11) NOT NULL DEFAULT '0',
				`actions` INT(11) NOT NULL DEFAULT '0',
				
				`sort_order` MEDIUMINT(5) NOT NULL DEFAULT '0',
				`is_pro`  TINYINT(1) NOT NULL DEFAULT '0',
				`ab_id`  INT(11) NOT NULL DEFAULT '0',
				
				`date_created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8;"));
		}
		self::initBaseForms();
		/**
		 * Contacts table
		 */
		if (!dbCfs::exist("@__contacts")) {
			dbDelta(dbCfs::prepareQuery("CREATE TABLE IF NOT EXISTS `@__contacts` (
				`id` INT(11) NOT NULL AUTO_INCREMENT,
				`form_id` INT(11) NOT NULL,
				`fields` TEXT NOT NULL,
				`ip` varchar(16) DEFAULT NULL,
				`url` varchar(255) DEFAULT NULL,

				`date_created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8;"));
		}
		/**
		* Plugin usage statistics
		*/
		if(!dbCfs::exist("@__usage_stat")) {
			dbDelta(dbCfs::prepareQuery("CREATE TABLE `@__usage_stat` (
			  `id` int(11) NOT NULL AUTO_INCREMENT,
			  `code` varchar(64) NOT NULL,
			  `visits` int(11) NOT NULL DEFAULT '0',
			  `spent_time` int(11) NOT NULL DEFAULT '0',
			  `modify_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
			  UNIQUE INDEX `code` (`code`),
			  PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8"));
			dbCfs::query("INSERT INTO `@__usage_stat` (code, visits) VALUES ('installed', 1)");
		}
		/**
		 * Statistics
		 */
		if (!dbCfs::exist("@__statistics")) {
			  dbDelta(dbCfs::prepareQuery("CREATE TABLE `@__statistics` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`form_id` int(11) NOT NULL DEFAULT '0',
				`type` TINYINT(2) NOT NULL DEFAULT '0',
				`is_unique` TINYINT(1) NOT NULL DEFAULT '0',
				`date_created` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (`id`)
			  ) DEFAULT CHARSET=utf8;"));
		}
		/**
		 * Countries
		 */
		if (!dbCfs::exist("@__countries")) {
			  dbDelta(dbCfs::prepareQuery("CREATE TABLE `@__countries` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`name` varchar(128) NOT NULL,
				`iso_code_2` varchar(2) DEFAULT NULL,
				`iso_code_3` varchar(3) DEFAULT NULL,
				PRIMARY KEY (`id`)
			  ) DEFAULT CHARSET=utf8;"));
			  self::_insertCountries();
		}
		installerDbUpdaterCfs::runUpdate();
		if($current_version && !self::$_firstTimeActivated) {
			self::setUsed();
			// For users that just updated our plugin - don't need tp show step-by-step tutorial
			update_user_meta(get_current_user_id(), CFS_CODE . '-tour-hst', array('closed' => 1));
		}
		update_option($wpPrefix. CFS_DB_PREF. 'db_version', CFS_VERSION);
		add_option($wpPrefix. CFS_DB_PREF. 'db_installed', 1);
	}
	static public function setUsed() {
		update_option(CFS_DB_PREF. 'plug_was_used', 1);
	}
	static public function isUsed() {
		return true;	// No welcome page for now
		//return 0;
		return (int) get_option(CFS_DB_PREF. 'plug_was_used');
	}
	static public function delete() {
		self::_checkSendStat('delete');
		global $wpdb;
		$wpPrefix = $wpdb->prefix;
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.CFS_DB_PREF."modules`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.CFS_DB_PREF."modules_type`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.CFS_DB_PREF."usage_stat`");
		//$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.CFS_DB_PREF."forms`");
		delete_option($wpPrefix. CFS_DB_PREF. 'db_version');
		delete_option($wpPrefix. CFS_DB_PREF. 'db_installed');
	}
	static public function deactivate() {
		self::_checkSendStat('deactivate');
	}
	static private function _checkSendStat($statCode) {
		if(class_exists('frameCfs') 
			&& frameCfs::_()->getModule('supsystic_promo')
			&& frameCfs::_()->getModule('options')
		) {
			frameCfs::_()->getModule('supsystic_promo')->getModel()->saveUsageStat( $statCode );
			frameCfs::_()->getModule('supsystic_promo')->getModel()->checkAndSend( true );
		}
	}
	static public function update() {
		global $wpdb;
		$wpPrefix = $wpdb->prefix; /* add to 0.0.3 Versiom */
		$currentVersion = get_option($wpPrefix. CFS_DB_PREF. 'db_version', 0);
		if(!$currentVersion || version_compare(CFS_VERSION, $currentVersion, '>')) {
			self::init( true );
			update_option($wpPrefix. CFS_DB_PREF. 'db_version', CFS_VERSION);
		}
	}
	static private function _insertCountries() {
		dbCfs::query('INSERT INTO @__countries VALUES 
			(1, "Afghanistan", "AF", "AFG"),
			(2, "Albania", "AL", "ALB"),
			(3, "Algeria", "DZ", "DZA"),
			(4, "American Samoa", "AS", "ASM"),
			(5, "Andorra", "AD", "AND"),
			(6, "Angola", "AO", "AGO"),
			(7, "Anguilla", "AI", "AIA"),
			(8, "Antarctica", "AQ", "ATA"),
			(9, "Antigua and Barbuda", "AG", "ATG"),
			(10, "Argentina", "AR", "ARG"),
			(11, "Armenia", "AM", "ARM"),
			(12, "Aruba", "AW", "ABW"),
			(13, "Australia", "AU", "AUS"),
			(14, "Austria", "AT", "AUT"),
			(15, "Azerbaijan", "AZ", "AZE"),
			(16, "Bahamas", "BS", "BHS"),
			(17, "Bahrain", "BH", "BHR"),
			(18, "Bangladesh", "BD", "BGD"),
			(19, "Barbados", "BB", "BRB"),
			(20, "Belarus", "BY", "BLR"),
			(21, "Belgium", "BE", "BEL"),
			(22, "Belize", "BZ", "BLZ"),
			(23, "Benin", "BJ", "BEN"),
			(24, "Bermuda", "BM", "BMU"),
			(25, "Bhutan", "BT", "BTN"),
			(26, "Bolivia", "BO", "BOL"),
			(27, "Bosnia and Herzegowina", "BA", "BIH"),
			(28, "Botswana", "BW", "BWA"),
			(29, "Bouvet Island", "BV", "BVT"),
			(30, "Brazil", "BR", "BRA"),
			(31, "British Indian Ocean Territory", "IO", "IOT"),
			(32, "Brunei Darussalam", "BN", "BRN"),
			(33, "Bulgaria", "BG", "BGR"),
			(34, "Burkina Faso", "BF", "BFA"),
			(35, "Burundi", "BI", "BDI"),
			(36, "Cambodia", "KH", "KHM"),
			(37, "Cameroon", "CM", "CMR"),
			(38, "Canada", "CA", "CAN"),
			(39, "Cape Verde", "CV", "CPV"),
			(40, "Cayman Islands", "KY", "CYM"),
			(41, "Central African Republic", "CF", "CAF"),
			(42, "Chad", "TD", "TCD"),
			(43, "Chile", "CL", "CHL"),
			(44, "China", "CN", "CHN"),
			(45, "Christmas Island", "CX", "CXR"),
			(46, "Cocos (Keeling) Islands", "CC", "CCK"),
			(47, "Colombia", "CO", "COL"),
			(48, "Comoros", "KM", "COM"),
			(49, "Congo", "CG", "COG"),
			(50, "Cook Islands", "CK", "COK"),
			(51, "Costa Rica", "CR", "CRI"),
			(52, "Cote D\'Ivoire", "CI", "CIV"),
			(53, "Croatia", "HR", "HRV"),
			(54, "Cuba", "CU", "CUB"),
			(55, "Cyprus", "CY", "CYP"),
			(56, "Czech Republic", "CZ", "CZE"),
			(57, "Denmark", "DK", "DNK"),
			(58, "Djibouti", "DJ", "DJI"),
			(59, "Dominica", "DM", "DMA"),
			(60, "Dominican Republic", "DO", "DOM"),
			(61, "East Timor", "TP", "TMP"),
			(62, "Ecuador", "EC", "ECU"),
			(63, "Egypt", "EG", "EGY"),
			(64, "El Salvador", "SV", "SLV"),
			(65, "Equatorial Guinea", "GQ", "GNQ"),
			(66, "Eritrea", "ER", "ERI"),
			(67, "Estonia", "EE", "EST"),
			(68, "Ethiopia", "ET", "ETH"),
			(69, "Falkland Islands (Malvinas)", "FK", "FLK"),
			(70, "Faroe Islands", "FO", "FRO"),
			(71, "Fiji", "FJ", "FJI"),
			(72, "Finland", "FI", "FIN"),
			(73, "France", "FR", "FRA"),
			(74, "France, Metropolitan", "FX", "FXX"),
			(75, "French Guiana", "GF", "GUF"),
			(76, "French Polynesia", "PF", "PYF"),
			(77, "French Southern Territories", "TF", "ATF"),
			(78, "Gabon", "GA", "GAB"),
			(79, "Gambia", "GM", "GMB"),
			(80, "Georgia", "GE", "GEO"),
			(81, "Germany", "DE", "DEU"),
			(82, "Ghana", "GH", "GHA"),
			(83, "Gibraltar", "GI", "GIB"),
			(84, "Greece", "GR", "GRC"),
			(85, "Greenland", "GL", "GRL"),
			(86, "Grenada", "GD", "GRD"),
			(87, "Guadeloupe", "GP", "GLP"),
			(88, "Guam", "GU", "GUM"),
			(89, "Guatemala", "GT", "GTM"),
			(90, "Guinea", "GN", "GIN"),
			(91, "Guinea-bissau", "GW", "GNB"),
			(92, "Guyana", "GY", "GUY"),
			(93, "Haiti", "HT", "HTI"),
			(94, "Heard and Mc Donald Islands", "HM", "HMD"),
			(95, "Honduras", "HN", "HND"),
			(96, "Hong Kong", "HK", "HKG"),
			(97, "Hungary", "HU", "HUN"),
			(98, "Iceland", "IS", "ISL"),
			(99, "India", "IN", "IND"),
			(100, "Indonesia", "ID", "IDN"),
			(101, "Iran (Islamic Republic of)", "IR", "IRN"),
			(102, "Iraq", "IQ", "IRQ"),
			(103, "Ireland", "IE", "IRL"),
			(104, "Israel", "IL", "ISR"),
			(105, "Italy", "IT", "ITA"),
			(106, "Jamaica", "JM", "JAM"),
			(107, "Japan", "JP", "JPN"),
			(108, "Jordan", "JO", "JOR"),
			(109, "Kazakhstan", "KZ", "KAZ"),
			(110, "Kenya", "KE", "KEN"),
			(111, "Kiribati", "KI", "KIR"),
			(112, "Korea, Democratic People\'s Republic of", "KP", "PRK"),
			(113, "Korea, Republic of", "KR", "KOR"),
			(114, "Kuwait", "KW", "KWT"),
			(115, "Kyrgyzstan", "KG", "KGZ"),
			(116, "Lao People\'s Democratic Republic", "LA", "LAO"),
			(117, "Latvia", "LV", "LVA"),
			(118, "Lebanon", "LB", "LBN"),
			(119, "Lesotho", "LS", "LSO"),
			(120, "Liberia", "LR", "LBR"),
			(121, "Libyan Arab Jamahiriya", "LY", "LBY"),
			(122, "Liechtenstein", "LI", "LIE"),
			(123, "Lithuania", "LT", "LTU"),
			(124, "Luxembourg", "LU", "LUX"),
			(125, "Macau", "MO", "MAC"),
			(126, "Macedonia, The Former Yugoslav Republic of", "MK", "MKD"),
			(127, "Madagascar", "MG", "MDG"),
			(128, "Malawi", "MW", "MWI"),
			(129, "Malaysia", "MY", "MYS"),
			(130, "Maldives", "MV", "MDV"),
			(131, "Mali", "ML", "MLI"),
			(132, "Malta", "MT", "MLT"),
			(133, "Marshall Islands", "MH", "MHL"),
			(134, "Martinique", "MQ", "MTQ"),
			(135, "Mauritania", "MR", "MRT"),
			(136, "Mauritius", "MU", "MUS"),
			(137, "Mayotte", "YT", "MYT"),
			(138, "Mexico", "MX", "MEX"),
			(139, "Micronesia, Federated States of", "FM", "FSM"),
			(140, "Moldova, Republic of", "MD", "MDA"),
			(141, "Monaco", "MC", "MCO"),
			(142, "Mongolia", "MN", "MNG"),
			(143, "Montenegro", "ME", "MNE"),
			(144, "Montserrat", "MS", "MSR"),
			(145, "Morocco", "MA", "MAR"),
			(146, "Mozambique", "MZ", "MOZ"),
			(147, "Myanmar", "MM", "MMR"),
			(148, "Namibia", "NA", "NAM"),
			(149, "Nauru", "NR", "NRU"),
			(150, "Nepal", "NP", "NPL"),
			(151, "Netherlands", "NL", "NLD"),
			(152, "Netherlands Antilles", "AN", "ANT"),
			(153, "New Caledonia", "NC", "NCL"),
			(154, "New Zealand", "NZ", "NZL"),
			(155, "Nicaragua", "NI", "NIC"),
			(156, "Niger", "NE", "NER"),
			(157, "Nigeria", "NG", "NGA"),
			(158, "Niue", "NU", "NIU"),
			(159, "Norfolk Island", "NF", "NFK"),
			(160, "Northern Mariana Islands", "MP", "MNP"),
			(161, "Norway", "NO", "NOR"),
			(162, "Oman", "OM", "OMN"),
			(163, "Pakistan", "PK", "PAK"),
			(164, "Palau", "PW", "PLW"),
			(165, "Panama", "PA", "PAN"),
			(166, "Papua New Guinea", "PG", "PNG"),
			(167, "Paraguay", "PY", "PRY"),
			(168, "Peru", "PE", "PER"),
			(169, "Philippines", "PH", "PHL"),
			(170, "Pitcairn", "PN", "PCN"),
			(171, "Poland", "PL", "POL"),
			(172, "Portugal", "PT", "PRT"),
			(173, "Puerto Rico", "PR", "PRI"),
			(174, "Qatar", "QA", "QAT"),
			(175, "Reunion", "RE", "REU"),
			(176, "Romania", "RO", "ROM"),
			(177, "Russian Federation", "RU", "RUS"),
			(178, "Rwanda", "RW", "RWA"),
			(179, "Saint Kitts and Nevis", "KN", "KNA"),
			(180, "Saint Lucia", "LC", "LCA"),
			(181, "Saint Vincent and the Grenadines", "VC", "VCT"),
			(182, "Samoa", "WS", "WSM"),
			(183, "San Marino", "SM", "SMR"),
			(184, "Sao Tome and Principe", "ST", "STP"),
			(185, "Saudi Arabia", "SA", "SAU"),
			(186, "Senegal", "SN", "SEN"),
			(187, "Serbia", "RS", "SRB"),
			(188, "Seychelles", "SC", "SYC"),
			(189, "Sierra Leone", "SL", "SLE"),
			(190, "Singapore", "SG", "SGP"),
			(191, "Slovakia (Slovak Republic)", "SK", "SVK"),
			(192, "Slovenia", "SI", "SVN"),
			(193, "Solomon Islands", "SB", "SLB"),
			(194, "Somalia", "SO", "SOM"),
			(195, "South Africa", "ZA", "ZAF"),
			(196, "South Georgia and the South Sandwich Islands", "GS", "SGS"),
			(197, "Spain", "ES", "ESP"),
			(198, "Sri Lanka", "LK", "LKA"),
			(199, "St. Helena", "SH", "SHN"),
			(200, "St. Pierre and Miquelon", "PM", "SPM"),
			(201, "Sudan", "SD", "SDN"),
			(202, "Suriname", "SR", "SUR"),
			(203, "Svalbard and Jan Mayen Islands", "SJ", "SJM"),
			(204, "Swaziland", "SZ", "SWZ"),
			(205, "Sweden", "SE", "SWE"),
			(206, "Switzerland", "CH", "CHE"),
			(207, "Syrian Arab Republic", "SY", "SYR"),
			(208, "Taiwan", "TW", "TWN"),
			(209, "Tajikistan", "TJ", "TJK"),
			(210, "Tanzania, United Republic of", "TZ", "TZA"),
			(211, "Thailand", "TH", "THA"),
			(212, "Togo", "TG", "TGO"),
			(213, "Tokelau", "TK", "TKL"),
			(214, "Tonga", "TO", "TON"),
			(215, "Trinidad and Tobago", "TT", "TTO"),
			(216, "Tunisia", "TN", "TUN"),
			(217, "Turkey", "TR", "TUR"),
			(218, "Turkmenistan", "TM", "TKM"),
			(219, "Turks and Caicos Islands", "TC", "TCA"),
			(220, "Tuvalu", "TV", "TUV"),
			(221, "Uganda", "UG", "UGA"),
			(222, "Ukraine", "UA", "UKR"),
			(223, "United Arab Emirates", "AE", "ARE"),
			(224, "United Kingdom", "GB", "GBR"),
			(225, "United States", "US", "USA"),
			(226, "United States Minor Outlying Islands", "UM", "UMI"),
			(227, "Uruguay", "UY", "URY"),
			(228, "Uzbekistan", "UZ", "UZB"),
			(229, "Vanuatu", "VU", "VUT"),
			(230, "Vatican City State (Holy See)", "VA", "VAT"),
			(231, "Venezuela", "VE", "VEN"),
			(232, "Viet Nam", "VN", "VNM"),
			(233, "Virgin Islands (British)", "VG", "VGB"),
			(234, "Virgin Islands (U.S.)", "VI", "VIR"),
			(235, "Wallis and Futuna Islands", "WF", "WLF"),
			(236, "Western Sahara", "EH", "ESH"),
			(237, "Yemen", "YE", "YEM"),
			(238, "Zaire", "ZR", "ZAR"),
			(239, "Zambia", "ZM", "ZMB"),
			(240, "Zimbabwe", "ZW", "ZWE")');
	}
	/*
	 * Init base forms templates
	 */
	static public function initBaseForms() {
		if(function_exists('base64_encode')) {
			$data = array(
				'wefj2' => array('unique_id' => 'wefj2','label' => 'Base Contact','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button{\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 18px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n    color: {{adjust_opacity(\"[bg_color_1]\", 0.7)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'base-contact.jpg'),
				'foe42k' => array('unique_id' => 'foe42k','label' => 'Neon','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] .cfsFieldCol {\r\n	padding: 10px 5px\r\n}\r\n/*Glow effect*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button {\r\n  	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0px 7px 5px -3px [bg_color_1];\r\n 	-moz-box-shadow: 0px 7px 5px -3px [bg_color_1];\r\n 	box-shadow: 0 7px 5px -3px [bg_color_1];\r\n	[endif]\r\n}\r\n#[SHELL_ID] textarea {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0 0 5px 1px [bg_color_1];\r\n 	-moz-box-shadow: 0 0 5px 1px [bg_color_1];\r\n 	box-shadow: 0 0 5px 1px [bg_color_1];\r\n	[endif]\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck {\r\n    padding: 0 5px 5px;\r\n    width: 100%;\r\n    font-size: 18px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border-top: none;\r\n  	border-left: none;\r\n  	border-right: none;\r\n  	border-bottom: 2px solid [bg_color_1];\r\n  	background-color: transparent;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	transition-duration: 0.4s;\r\n  	font-style: italic;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] textarea {\r\n  	padding: 5px;\r\n	[if bg_type_1 == \'color\']\r\n  	border: 2px solid [bg_color_1];\r\n  	[endif]\r\n}\r\n/*Invalid input styles*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus:invalid,\r\n#[SHELL_ID] textarea:focus:invalid,\r\n#[SHELL_ID] .cfsListSelect:focus:invalid, \r\n#[SHELL_ID] .cfsCheck:focus:invalid {\r\n	border-color: #ff0004;\r\n  	box-shadow: none;\r\n  	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0px 7px 5px -3px #ff0004;\r\n 	-moz-box-shadow: 0px 7px 5px -3px #ff0004;\r\n 	box-shadow: 0 7px 5px -3px #ff0004;\r\n	[endif]\r\n}\r\n#[SHELL_ID] textarea:focus:invalid {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0 0 5px 1px #ff0004;\r\n 	-moz-box-shadow: 0 0 5px 1px #ff0004;\r\n 	box-shadow: 0 0 5px 1px #ff0004;\r\n	[endif]\r\n}\r\n/*Some interactions with inputs*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0px 9px 5px -3px [bg_color_1];\r\n 	-moz-box-shadow: 0px 9px 5px -3px [bg_color_1];\r\n 	box-shadow: 0 9px 5px -3px [bg_color_1];\r\n	[endif]\r\n}\r\n#[SHELL_ID] textarea:focus {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0 0 5px 3px [bg_color_1];\r\n 	-moz-box-shadow: 0 0 5px 3px [bg_color_1];\r\n 	box-shadow: 0 0 5px 3px [bg_color_1];\r\n	[endif]\r\n}\r\n/*Buttons*/\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	width: auto;\r\n    text-transform: uppercase;\r\n  	font-size: 34px;\r\n  	padding: 10px 20px;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	border: 2px solid [bg_color_2];\r\n  	background-color: transparent;\r\n  	background-image: none;\r\n  	color: [bg_color_2];\r\n  \r\n  	-webkit-box-shadow: 0 0 5px 1px [bg_color_2];\r\n 	-moz-box-shadow: 0 0 5px 1px [bg_color_2];\r\n 	box-shadow: 0 0 5px 1px [bg_color_2];\r\n  \r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	color: #fff;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	border: 2px solid [bg_color_3];\r\n  	background-color: transparent;\r\n  	background-image: none;\r\n  	color: [bg_color_3];\r\n  \r\n  	-webkit-box-shadow: 0 0 5px 1px [bg_color_3];\r\n 	-moz-box-shadow: 0 0 5px 1px [bg_color_3];\r\n 	box-shadow: 0 0 5px 1px [bg_color_3];\r\n  \r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	color: #fff;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n  	font-style: italic;\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n  	font-style: italic;\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n  	font-style: italic;\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n  	font-style: italic;\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'neon.jpg'),
				'uwi23o' => array('unique_id' => 'uwi23o','label' => 'Intransigent','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Form theme custom styles*/\r\n#[SHELL_ID] .cfsFieldShell:not([data-field-html=\"submit\"]):not([data-field-html=\"reset\"]):not([data-field-html=\"button\"]) {\r\n	[if bg_type_1 == \'color\']\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 11)}};\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell[data-field-html=\"submit\"] .cfsFieldInputEx input,\r\n#[SHELL_ID] .cfsFieldShell[data-field-html=\"reset\"] .cfsFieldInputEx input,\r\n#[SHELL_ID] .cfsFieldShell[data-field-html=\"button\"] .cfsFieldInputEx input {\r\n	float: right;\r\n}\r\n#[SHELL_ID] .cfsFieldExLabel {\r\n  	font-size: 14px;\r\n  	padding: 10px 25px;\r\n	[if bg_type_1 == \'color\']\r\n  	color: {{adjust_brightness(\"[bg_color_1]\", 109)}};\r\n  	[endif]\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button  {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 15px;\r\n    line-height: normal;\r\n  	border: none;\r\n  	border-radius: 0;\r\n  	hyphens: none;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	transition-duration: 0.3s;\r\n  	[if bg_type_1 == \'color\']\r\n    color: {{adjust_brightness(\"[bg_color_1]\", 109)}};\r\n  	background-color: [bg_color_1];\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: normal;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	width: auto;\r\n  	font-size: 20px;\r\n  	padding: 15px 25px;\r\n  	opacity: 0.7;\r\n  	[if bg_type_1 == \'color\']\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", -20)}};\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	opacity: 1;\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'intransigent.jpg'),
				'vbn23a' => array('unique_id' => 'vbn23a','label' => 'Simple White','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 1)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 4px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	color: #333;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsChec:focus {\r\n	[if bg_type_2 == \'color\']\r\n  	border: 1px solid [bg_color_2];\r\n  	color: [bg_color_2];\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'simple-white.png'),
				'bso15i' => array('unique_id' => 'bso15i','label' => 'Time for tea','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\n[fields]\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;/**/\r\n	background-position: bottom right;\r\n  	[endif]\r\n	font-family: \"Raleway\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n  	color: #FFF;\r\n  	font-size: 14px;\r\n}\r\n\r\n#[SHELL_ID] h3 {\r\n  	font-weight: bold;\r\n  	font-size: 24px;\r\n  	margin-top: 30px;\r\n  	margin-bottom: 15px;\r\n}\r\n\r\n#[SHELL_ID] label {\r\n  	font-weight: bold;\r\n}\r\n\r\n#[SHELL_ID] form {\r\n  	padding: 0 25px 25px;\r\n	[if bg_type_1 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n  	/*padding-left: 10px;/**/\r\n  	color: #FFF;\r\n	width: 100%;\r\n  	font-size: 14px;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button {\r\n  	border: 1px solid #FFF;\r\n  	color: #FFF;\r\n    padding: 10px;\r\n    width: 100%;\r\n    line-height: normal;\r\n  	background-color: inherit;\r\n    hyphens: none;\r\n    border-radius: 4px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n\r\n#[SHELL_ID] .g-recaptcha {\r\n	min-height: 60px;\r\n}\r\n\r\n#[SHELL_ID] [type=\"submit\"] {\r\n  	margin-top: 40px !important;\r\n	width: 150px !important;\r\n  	font-size: 24px;\r\n  	text-transform: capitalize !important;\r\n  	border-radius: 25px !important;\r\n  	float: right;\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'tea-time.png'),
				'bjl17b' => array('unique_id' => 'bjl17b','label' => 'Opacity Grey','active' => '1','original_id' => '0','params' => 'YTo0OntzOjM6InRwbCI7YToyMDp7czo1OiJ3aWR0aCI7czozOiIxMDAiO3M6MTM6IndpZHRoX21lYXN1cmUiO3M6MToiJSI7czo5OiJiZ190eXBlXzAiO3M6NToiY29sb3IiO3M6ODoiYmdfaW1nXzAiO3M6MDoiIjtzOjEwOiJiZ19jb2xvcl8wIjtzOjc6IiMzMzMzMzMiO3M6OToiYmdfdHlwZV8xIjtzOjQ6Im5vbmUiO3M6ODoiYmdfaW1nXzEiO3M6MDoiIjtzOjEwOiJiZ19jb2xvcl8xIjtzOjc6IiNmZmZmZmYiO3M6OToiYmdfdHlwZV8yIjtzOjU6ImNvbG9yIjtzOjg6ImJnX2ltZ18yIjtzOjA6IiI7czoxMDoiYmdfY29sb3JfMiI7czo3OiIjZWY2MTYxIjtzOjk6ImJnX3R5cGVfMyI7czo1OiJjb2xvciI7czo4OiJiZ19pbWdfMyI7czowOiIiO3M6MTA6ImJnX2NvbG9yXzMiO3M6NzoiI2RkMzMzMyI7czoxOToiZmllbGRfZXJyb3JfaW52YWxpZCI7czowOiIiO3M6MTM6ImZvcm1fc2VudF9tc2ciO3M6Mjg6IlRoYW5rIHlvdSBmb3IgY29udGFjdGluZyB1cyEiO3M6MTg6InJlZGlyZWN0X29uX3N1Ym1pdCI7czowOiIiO3M6MTA6InRlc3RfZW1haWwiO3M6MTQ6ImFkbWluQG1haWwuY29tIjtzOjEzOiJzYXZlX2NvbnRhY3RzIjtzOjE6IjEiO3M6MTM6ImZpZWxkX3dyYXBwZXIiO3M6NjE6IjxkaXYgW2ZpZWxkX3NoZWxsX2NsYXNzZXNdIFtmaWVsZF9zaGVsbF9zdHlsZXNdPltmaWVsZF08L2Rpdj4iO31zOjY6ImZpZWxkcyI7YTo2OntpOjA7YToxNzp7czo1OiJsYWJlbCI7czowOiIiO3M6MTE6InBsYWNlaG9sZGVyIjtzOjA6IiI7czo0OiJodG1sIjtzOjk6Imh0bWxkZWxpbSI7czo1OiJ2YWx1ZSI7czoyMjU6IjxkaXYgY2xhc3M9XCJwYXBlci1wbGFuZVwiPjxpbWcgc3JjPVwiW0NGU19BU1NFVFNfVVJMXWltZy9pbWFnZXMvcGFwZXItcGxhbmUucG5nXCIgPjwvZGl2Pg0KPGRpdiBjbGFzcz1cImZhIGZhLXBhcGVyLXBsYW5lLW9cIj48L2Rpdj4NCjxoMz5Db250YWN0IFVzPC9oMz4NCjxwPkRvblwndCBoZXNpdGF0ZSB0byBjb250YWN0IHVzLCB3ZVwnbGwgYW5zd2VyIHlvdSBhbnl0aW1lIHNvb24hPC9wPiI7czo5OiJtYW5kYXRvcnkiO3M6MToiMCI7czo0OiJuYW1lIjtzOjA6IiI7czoxMToiYnNfY2xhc3NfaWQiO3M6MjoiMTIiO3M6NzoiZGlzcGxheSI7czowOiIiO3M6ODoibWluX3NpemUiO3M6MDoiIjtzOjg6Im1heF9zaXplIjtzOjA6IiI7czoxMToiYWRkX2NsYXNzZXMiO3M6MDoiIjtzOjEwOiJhZGRfc3R5bGVzIjtzOjA6IiI7czo4OiJhZGRfYXR0ciI7czowOiIiO3M6MTQ6InZuX29ubHlfbnVtYmVyIjtzOjE6IjAiO3M6MTU6InZuX29ubHlfbGV0dGVycyI7czoxOiIwIjtzOjEwOiJ2bl9wYXR0ZXJuIjtzOjA6IiI7czoxMToiZGVmX2NoZWNrZWQiO3M6MToiMCI7fWk6MTthOjE3OntzOjU6ImxhYmVsIjtzOjA6IiI7czoxMToicGxhY2Vob2xkZXIiO3M6NDoiTmFtZSI7czo0OiJodG1sIjtzOjQ6InRleHQiO3M6NToidmFsdWUiO3M6MDoiIjtzOjk6Im1hbmRhdG9yeSI7czoxOiIxIjtzOjQ6Im5hbWUiO3M6MTA6ImZpcnN0X25hbWUiO3M6MTE6ImJzX2NsYXNzX2lkIjtzOjI6IjEyIjtzOjc6ImRpc3BsYXkiO3M6MDoiIjtzOjg6Im1pbl9zaXplIjtzOjA6IiI7czo4OiJtYXhfc2l6ZSI7czowOiIiO3M6MTE6ImFkZF9jbGFzc2VzIjtzOjA6IiI7czoxMDoiYWRkX3N0eWxlcyI7czowOiIiO3M6ODoiYWRkX2F0dHIiO3M6MDoiIjtzOjE0OiJ2bl9vbmx5X251bWJlciI7czoxOiIwIjtzOjE1OiJ2bl9vbmx5X2xldHRlcnMiO3M6MToiMCI7czoxMDoidm5fcGF0dGVybiI7czoxOiIwIjtzOjExOiJkZWZfY2hlY2tlZCI7czoxOiIwIjt9aToyO2E6MTc6e3M6NToibGFiZWwiO3M6MDoiIjtzOjExOiJwbGFjZWhvbGRlciI7czo1OiJFbWFpbCI7czo0OiJodG1sIjtzOjU6ImVtYWlsIjtzOjU6InZhbHVlIjtzOjA6IiI7czo5OiJtYW5kYXRvcnkiO3M6MToiMSI7czo0OiJuYW1lIjtzOjU6ImVtYWlsIjtzOjExOiJic19jbGFzc19pZCI7czoyOiIxMiI7czo3OiJkaXNwbGF5IjtzOjM6InJvdyI7czo4OiJtaW5fc2l6ZSI7czowOiIiO3M6ODoibWF4X3NpemUiO3M6MDoiIjtzOjExOiJhZGRfY2xhc3NlcyI7czowOiIiO3M6MTA6ImFkZF9zdHlsZXMiO3M6MDoiIjtzOjg6ImFkZF9hdHRyIjtzOjA6IiI7czoxNDoidm5fb25seV9udW1iZXIiO3M6MToiMCI7czoxNToidm5fb25seV9sZXR0ZXJzIjtzOjE6IjAiO3M6MTA6InZuX3BhdHRlcm4iO3M6MToiMCI7czoxMToiZGVmX2NoZWNrZWQiO3M6MToiMCI7fWk6MzthOjE3OntzOjU6ImxhYmVsIjtzOjA6IiI7czoxMToicGxhY2Vob2xkZXIiO3M6MTI6IlBob25lIE51bWJlciI7czo0OiJodG1sIjtzOjQ6InRleHQiO3M6NToidmFsdWUiO3M6MDoiIjtzOjk6Im1hbmRhdG9yeSI7czoxOiIwIjtzOjQ6Im5hbWUiO3M6NToicGhvbmUiO3M6MTE6ImJzX2NsYXNzX2lkIjtzOjI6IjEyIjtzOjc6ImRpc3BsYXkiO3M6Mzoicm93IjtzOjg6Im1pbl9zaXplIjtzOjA6IiI7czo4OiJtYXhfc2l6ZSI7czowOiIiO3M6MTE6ImFkZF9jbGFzc2VzIjtzOjA6IiI7czoxMDoiYWRkX3N0eWxlcyI7czowOiIiO3M6ODoiYWRkX2F0dHIiO3M6MDoiIjtzOjE0OiJ2bl9vbmx5X251bWJlciI7czoxOiIwIjtzOjE1OiJ2bl9vbmx5X2xldHRlcnMiO3M6MToiMCI7czoxMDoidm5fcGF0dGVybiI7czoxOiIwIjtzOjExOiJkZWZfY2hlY2tlZCI7czoxOiIwIjt9aTo0O2E6MTc6e3M6NToibGFiZWwiO3M6MDoiIjtzOjExOiJwbGFjZWhvbGRlciI7czo3OiJNZXNzYWdlIjtzOjQ6Imh0bWwiO3M6ODoidGV4dGFyZWEiO3M6NToidmFsdWUiO3M6MDoiIjtzOjk6Im1hbmRhdG9yeSI7czoxOiIxIjtzOjQ6Im5hbWUiO3M6NzoibWVzc2FnZSI7czoxMToiYnNfY2xhc3NfaWQiO3M6MjoiMTIiO3M6NzoiZGlzcGxheSI7czozOiJyb3ciO3M6ODoibWluX3NpemUiO3M6MDoiIjtzOjg6Im1heF9zaXplIjtzOjA6IiI7czoxMToiYWRkX2NsYXNzZXMiO3M6MDoiIjtzOjEwOiJhZGRfc3R5bGVzIjtzOjA6IiI7czo4OiJhZGRfYXR0ciI7czowOiIiO3M6MTQ6InZuX29ubHlfbnVtYmVyIjtzOjE6IjAiO3M6MTU6InZuX29ubHlfbGV0dGVycyI7czoxOiIwIjtzOjEwOiJ2bl9wYXR0ZXJuIjtzOjE6IjAiO3M6MTE6ImRlZl9jaGVja2VkIjtzOjE6IjAiO31pOjU7YToxNzp7czo1OiJsYWJlbCI7czo0OiJTZW5kIjtzOjExOiJwbGFjZWhvbGRlciI7czowOiIiO3M6NDoiaHRtbCI7czo2OiJzdWJtaXQiO3M6NToidmFsdWUiO3M6MDoiIjtzOjk6Im1hbmRhdG9yeSI7czoxOiIwIjtzOjQ6Im5hbWUiO3M6NDoic2VuZCI7czoxMToiYnNfY2xhc3NfaWQiO3M6MjoiMTIiO3M6NzoiZGlzcGxheSI7czowOiIiO3M6ODoibWluX3NpemUiO3M6MDoiIjtzOjg6Im1heF9zaXplIjtzOjA6IiI7czoxMToiYWRkX2NsYXNzZXMiO3M6MDoiIjtzOjEwOiJhZGRfc3R5bGVzIjtzOjA6IiI7czo4OiJhZGRfYXR0ciI7czowOiIiO3M6MTQ6InZuX29ubHlfbnVtYmVyIjtzOjE6IjAiO3M6MTU6InZuX29ubHlfbGV0dGVycyI7czoxOiIwIjtzOjEwOiJ2bl9wYXR0ZXJuIjtzOjE6IjAiO3M6MTE6ImRlZl9jaGVja2VkIjtzOjE6IjAiO319czo2OiJzdWJtaXQiO2E6MTp7aTowO2E6Nzp7czoyOiJ0byI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6NDoiZnJvbSI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MjoiY2MiO3M6MDoiIjtzOjU6InJlcGx5IjtzOjA6IiI7czo3OiJzdWJqZWN0IjtzOjE5OiJDb250YWN0IGZvcm0gc3VibWl0IjtzOjM6Im1zZyI7czo3MzoiPHA+SGVsbG8hPC9wPg0KPHA+VGhpcyBpcyB5b3VyIGNvbnRhY3QgZm9ybSBkYXRhOjwvcD4NCjxwPltmb3JtX2RhdGFdPC9wPiI7czo2OiJlbmJfY2MiO3M6MToiMCI7fX1zOjEwOiJvcHRzX2F0dHJzIjthOjE6e3M6OToiYmdfbnVtYmVyIjtzOjE6IjQiO319','html' => '[form_start]\n[fields]\n[form_end]','css' => '@import url(\'https://fonts.googleapis.com/css?family=Raleway\'); \r\n\r\n#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_0]\", 0.85)}};\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n  	color: #FFF;\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] h3, #[SHELL_ID] p {\r\n  	margin: 10px 0;\r\n  	text-align: center;\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID] .paper-plane {\r\n  	margin-top: 20px;\r\n  	height: 32px;\r\n  	text-align: center;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[else]\r\n  	border: 1px solid transparent;\r\n  	border-bottom-color: #FFF;\r\n  	background: transparent;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	color: #FFF;\r\n  	font-family: Raleway, sans-serif !important;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n  	outline: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n  	/* text-transform: capitalize;/**/\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	color: [bg_color_2];\r\n  	background-color: #FFF;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'opacity-grey.png'),
				'bjl17a' => array('unique_id' => 'bjl17a','label' => 'Spearmint','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\n[fields]\n[form_end]','css' => '@import url(\'https://fonts.googleapis.com/css?family=Kaushan+Script\'); \r\n\r\n#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 14px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n    color: {{adjust_opacity(\"[bg_color_1]\", 1)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 2px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	box-shadow: rgba(0, 0, 0, 0.0980392) 0px 4px 0px 0px inset;\r\n  	width: 150px;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'light-grey.png'),
				'bjl17c' => array('unique_id' => 'bjl17c','label' => 'Support Service','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\n[fields]\n[form_end]','css' => '#[SHELL_ID] {\r\n  	[if bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[elseif bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	[else]\r\n  	background-color: #FFF;\r\n  	[endif]\r\n  	font-family: sans-serif;\r\n  	padding: 20px;\r\n  	width: 380px;\r\n}\r\n\r\n#[SHELL_ID] .about,\r\n#[SHELL_ID] p {\r\n  	margin: 0;\r\n	text-align: center;\r\n  	color: #FFF;\r\n  	font-size: 14px;\r\n  	line-height: 1em;\r\n}\r\n\r\n#[SHELL_ID] .cfsFieldShell {\r\n	position: relative;\r\n}\r\n\r\n#[SHELL_ID] .cfsFieldShell select {\r\n	position: absolute;\r\n  	padding-left: 5px;\r\n  	top: 0;\r\n  	left: 0;\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	box-sizing: border-box;\r\n  	font-family: sans-serif;\r\n  	font-size: 12px;\r\n  	color: #666059;\r\n}\r\n\r\n#[SHELL_ID] p.description {\r\n  	line-height: 18px;\r\n}\r\n\r\n#[SHELL_ID] .about div {\r\n	height: 100px;\r\n  	margin-bottom: 20px;\r\n  	margin-right: 40px;\r\n}\r\n\r\n#[SHELL_ID] div .name {\r\n	font-size: 30px;\r\n  	line-height: 1.8em;\r\n}\r\n\r\n#[SHELL_ID] div .role {\r\n    margin-top: -5px;\r\n}\r\n\r\n#[SHELL_ID] .about > img {\r\n  	width: 100px;\r\n  	height: 100px;\r\n  	margin-right: 20px;\r\n  	margin-bottom: 20px;\r\n  	float: left;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons {\r\n  	margin-top: 17px;\r\n	margin-left: 120px;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons a {\r\n  	font-size: 0;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons a + a {\r\n  	padding-left: 3px;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons img {\r\n  	display: inline-block;\r\n	height: 16px;\r\n  	width: 16px;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons img:hover {\r\n  	opacity: 0.5;\r\n}\r\n\r\n\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n  	[if bg_type_2 == \'color\']\r\n	border: 1px solid {{adjust_opacity(\"[bg_color_2]\", 0.5)}};\r\n  	[endif]\r\n  	[if bg_type_0 == \'color\']\r\n	background-color: [bg_color_0];\r\n  	[endif]\r\n  	[if bg_type_1 == \'color\']\r\n	color: [bg_color_1];\r\n  	[endif]  \r\n    hyphens: none;\r\n    border-radius: 3px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] input:focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n    outline: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	width: 50%;\r\n  	float: right;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'kiwifruit.png'),
			);
		} else {	//--not-base64--
			$data = array(
				'wefj2' => array('unique_id' => 'wefj2','label' => 'Base Contact','active' => '1','original_id' => '0','params' => '97|58|52|58|123|115|58|51|58|34|116|112|108|34|59|97|58|50|48|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|56|49|100|55|52|50|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|55|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|48|58|34|70|105|114|115|116|32|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|48|58|34|102|105|114|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|57|58|34|76|97|115|116|32|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|57|58|34|108|97|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|83|117|98|106|101|99|116|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|54|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|53|58|34|82|101|115|101|116|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|114|101|115|101|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|114|101|115|101|116|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button{\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 18px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n    color: {{adjust_opacity(\"[bg_color_1]\", 0.7)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'base-contact.jpg'),
				'foe42k' => array('unique_id' => 'foe42k','label' => 'Neon','active' => '1','original_id' => '0','params' => '97|58|52|58|123|115|58|51|58|34|116|112|108|34|59|97|58|50|48|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|56|49|100|55|52|50|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|48|50|52|102|102|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|48|50|52|102|102|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|54|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|52|58|34|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|67|111|109|112|97|110|121|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|99|111|109|112|97|110|121|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|56|58|34|81|117|101|115|116|105|111|110|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|56|58|34|113|117|101|115|116|105|111|110|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] .cfsFieldCol {\r\n	padding: 10px 5px\r\n}\r\n/*Glow effect*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button {\r\n  	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0px 7px 5px -3px [bg_color_1];\r\n 	-moz-box-shadow: 0px 7px 5px -3px [bg_color_1];\r\n 	box-shadow: 0 7px 5px -3px [bg_color_1];\r\n	[endif]\r\n}\r\n#[SHELL_ID] textarea {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0 0 5px 1px [bg_color_1];\r\n 	-moz-box-shadow: 0 0 5px 1px [bg_color_1];\r\n 	box-shadow: 0 0 5px 1px [bg_color_1];\r\n	[endif]\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck {\r\n    padding: 0 5px 5px;\r\n    width: 100%;\r\n    font-size: 18px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border-top: none;\r\n  	border-left: none;\r\n  	border-right: none;\r\n  	border-bottom: 2px solid [bg_color_1];\r\n  	background-color: transparent;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	transition-duration: 0.4s;\r\n  	font-style: italic;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] textarea {\r\n  	padding: 5px;\r\n	[if bg_type_1 == \'color\']\r\n  	border: 2px solid [bg_color_1];\r\n  	[endif]\r\n}\r\n/*Invalid input styles*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus:invalid,\r\n#[SHELL_ID] textarea:focus:invalid,\r\n#[SHELL_ID] .cfsListSelect:focus:invalid, \r\n#[SHELL_ID] .cfsCheck:focus:invalid {\r\n	border-color: #ff0004;\r\n  	box-shadow: none;\r\n  	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0px 7px 5px -3px #ff0004;\r\n 	-moz-box-shadow: 0px 7px 5px -3px #ff0004;\r\n 	box-shadow: 0 7px 5px -3px #ff0004;\r\n	[endif]\r\n}\r\n#[SHELL_ID] textarea:focus:invalid {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0 0 5px 1px #ff0004;\r\n 	-moz-box-shadow: 0 0 5px 1px #ff0004;\r\n 	box-shadow: 0 0 5px 1px #ff0004;\r\n	[endif]\r\n}\r\n/*Some interactions with inputs*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0px 9px 5px -3px [bg_color_1];\r\n 	-moz-box-shadow: 0px 9px 5px -3px [bg_color_1];\r\n 	box-shadow: 0 9px 5px -3px [bg_color_1];\r\n	[endif]\r\n}\r\n#[SHELL_ID] textarea:focus {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0 0 5px 3px [bg_color_1];\r\n 	-moz-box-shadow: 0 0 5px 3px [bg_color_1];\r\n 	box-shadow: 0 0 5px 3px [bg_color_1];\r\n	[endif]\r\n}\r\n/*Buttons*/\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	width: auto;\r\n    text-transform: uppercase;\r\n  	font-size: 34px;\r\n  	padding: 10px 20px;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	border: 2px solid [bg_color_2];\r\n  	background-color: transparent;\r\n  	background-image: none;\r\n  	color: [bg_color_2];\r\n  \r\n  	-webkit-box-shadow: 0 0 5px 1px [bg_color_2];\r\n 	-moz-box-shadow: 0 0 5px 1px [bg_color_2];\r\n 	box-shadow: 0 0 5px 1px [bg_color_2];\r\n  \r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	color: #fff;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	border: 2px solid [bg_color_3];\r\n  	background-color: transparent;\r\n  	background-image: none;\r\n  	color: [bg_color_3];\r\n  \r\n  	-webkit-box-shadow: 0 0 5px 1px [bg_color_3];\r\n 	-moz-box-shadow: 0 0 5px 1px [bg_color_3];\r\n 	box-shadow: 0 0 5px 1px [bg_color_3];\r\n  \r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	color: #fff;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n  	font-style: italic;\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n  	font-style: italic;\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n  	font-style: italic;\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n  	font-style: italic;\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'neon.jpg'),
				'uwi23o' => array('unique_id' => 'uwi23o','label' => 'Intransigent','active' => '1','original_id' => '0','params' => '97|58|52|58|123|115|58|51|58|34|116|112|108|34|59|97|58|49|52|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|56|49|100|55|52|50|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|49|57|49|57|49|57|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|50|53|50|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|32|100|97|116|97|45|102|105|101|108|100|45|104|116|109|108|61|92|34|91|102|105|101|108|100|95|104|116|109|108|93|92|34|62|60|100|105|118|32|99|108|97|115|115|61|92|34|114|111|119|92|34|62|60|100|105|118|32|99|108|97|115|115|61|92|34|99|111|108|45|115|109|45|51|32|99|102|115|70|105|101|108|100|69|120|76|97|98|101|108|92|34|62|60|108|97|98|101|108|32|102|111|114|61|92|34|91|102|105|101|108|100|95|105|100|93|92|34|62|91|108|97|98|101|108|93|60|47|108|97|98|101|108|62|60|47|100|105|118|62|60|100|105|118|32|99|108|97|115|115|61|92|34|99|111|108|45|115|109|45|57|32|99|102|115|70|105|101|108|100|73|110|112|117|116|69|120|92|34|62|91|102|105|101|108|100|93|60|47|100|105|118|62|60|47|100|105|118|62|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|52|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|78|97|109|101|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|50|34|59|125|125:ORD_ENC','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Form theme custom styles*/\r\n#[SHELL_ID] .cfsFieldShell:not([data-field-html=\"submit\"]):not([data-field-html=\"reset\"]):not([data-field-html=\"button\"]) {\r\n	[if bg_type_1 == \'color\']\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 11)}};\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell[data-field-html=\"submit\"] .cfsFieldInputEx input,\r\n#[SHELL_ID] .cfsFieldShell[data-field-html=\"reset\"] .cfsFieldInputEx input,\r\n#[SHELL_ID] .cfsFieldShell[data-field-html=\"button\"] .cfsFieldInputEx input {\r\n	float: right;\r\n}\r\n#[SHELL_ID] .cfsFieldExLabel {\r\n  	font-size: 14px;\r\n  	padding: 10px 25px;\r\n	[if bg_type_1 == \'color\']\r\n  	color: {{adjust_brightness(\"[bg_color_1]\", 109)}};\r\n  	[endif]\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button  {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 15px;\r\n    line-height: normal;\r\n  	border: none;\r\n  	border-radius: 0;\r\n  	hyphens: none;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	transition-duration: 0.3s;\r\n  	[if bg_type_1 == \'color\']\r\n    color: {{adjust_brightness(\"[bg_color_1]\", 109)}};\r\n  	background-color: [bg_color_1];\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: normal;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	width: auto;\r\n  	font-size: 20px;\r\n  	padding: 15px 25px;\r\n  	opacity: 0.7;\r\n  	[if bg_type_1 == \'color\']\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", -20)}};\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	opacity: 1;\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'intransigent.jpg'),
				'vbn23a' => array('unique_id' => 'vbn23a','label' => 'Simple White','active' => '1','original_id' => '0','params' => '97|58|52|58|123|115|58|51|58|34|116|112|108|34|59|97|58|50|48|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|99|100|99|100|99|100|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|99|100|99|100|99|100|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|55|97|102|57|55|99|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|102|102|56|48|55|99|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|55|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|48|58|34|70|105|114|115|116|32|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|48|58|34|102|105|114|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|57|58|34|76|97|115|116|32|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|57|58|34|108|97|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|83|117|98|106|101|99|116|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|54|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|53|58|34|82|101|115|101|116|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|114|101|115|101|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|114|101|115|101|116|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 1)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 4px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	color: #333;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsChec:focus {\r\n	[if bg_type_2 == \'color\']\r\n  	border: 1px solid [bg_color_2];\r\n  	color: [bg_color_2];\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'simple-white.png'),
				'bso15i' => array('unique_id' => 'bso15i','label' => 'Time for tea','active' => '1','original_id' => '0','params' => '97|58|52|58|123|115|58|51|58|34|116|112|108|34|59|97|58|50|48|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|51|58|34|105|109|103|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|51|53|58|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|98|103|47|116|101|97|45|116|105|109|101|46|112|110|103|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|102|57|54|57|48|101|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|100|100|51|51|51|51|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|49|49|48|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|13|10|32|32|32|32|60|108|97|98|101|108|32|102|111|114|61|92|34|91|102|105|101|108|100|95|105|100|93|92|34|62|91|108|97|98|101|108|93|60|47|108|97|98|101|108|62|91|102|105|101|108|100|93|13|10|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|55|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|104|116|109|108|100|101|108|105|109|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|50|50|56|58|34|60|104|51|32|99|108|97|115|115|61|92|34|104|101|97|100|95|102|111|114|109|92|34|62|67|111|110|116|97|99|116|32|85|115|60|47|104|51|62|13|10|60|112|32|99|108|97|115|115|61|92|34|100|101|115|99|114|105|112|116|105|111|110|92|34|62|73|102|32|121|111|117|32|104|97|118|101|32|115|111|109|101|32|113|117|101|115|116|105|111|110|115|32|111|114|32|111|102|102|101|114|115|32|102|111|114|32|117|115|32|45|32|102|105|108|108|32|116|104|101|32|99|111|110|116|97|99|116|32|102|111|114|109|32|98|101|108|111|119|46|32|79|117|114|32|115|117|112|112|111|114|116|32|116|101|97|109|32|105|115|32|104|97|112|112|121|32|116|111|32|104|101|108|112|32|121|111|117|32|50|52|47|55|32|97|110|100|32|119|101|32|99|97|110|32|97|110|115|119|101|114|32|101|118|101|114|121|32|121|111|117|114|32|113|117|101|115|116|105|111|110|46|60|47|112|62|13|10|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|49|48|58|34|70|105|114|115|116|32|78|97|109|101|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|48|58|34|102|105|114|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|57|58|34|76|97|115|116|32|78|97|109|101|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|57|58|34|108|97|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|50|50|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|54|58|34|67|97|112|99|104|97|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|114|101|99|97|112|116|99|104|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|54|58|34|99|97|112|99|104|97|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|115|58|49|51|58|34|114|101|99|97|112|45|115|105|116|101|107|101|121|34|59|115|58|48|58|34|34|59|115|58|49|50|58|34|114|101|99|97|112|45|115|101|99|114|101|116|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|114|101|99|97|112|45|116|104|101|109|101|34|59|115|58|53|58|34|108|105|103|104|116|34|59|115|58|49|48|58|34|114|101|99|97|112|45|116|121|112|101|34|59|115|58|53|58|34|97|117|100|105|111|34|59|115|58|49|48|58|34|114|101|99|97|112|45|115|105|122|101|34|59|115|58|54|58|34|110|111|114|109|97|108|34|59|125|105|58|54|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\n[fields]\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;/**/\r\n	background-position: bottom right;\r\n  	[endif]\r\n	font-family: \"Raleway\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n  	color: #FFF;\r\n  	font-size: 14px;\r\n}\r\n\r\n#[SHELL_ID] h3 {\r\n  	font-weight: bold;\r\n  	font-size: 24px;\r\n  	margin-top: 30px;\r\n  	margin-bottom: 15px;\r\n}\r\n\r\n#[SHELL_ID] label {\r\n  	font-weight: bold;\r\n}\r\n\r\n#[SHELL_ID] form {\r\n  	padding: 0 25px 25px;\r\n	[if bg_type_1 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n  	/*padding-left: 10px;/**/\r\n  	color: #FFF;\r\n	width: 100%;\r\n  	font-size: 14px;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button {\r\n  	border: 1px solid #FFF;\r\n  	color: #FFF;\r\n    padding: 10px;\r\n    width: 100%;\r\n    line-height: normal;\r\n  	background-color: inherit;\r\n    hyphens: none;\r\n    border-radius: 4px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n\r\n#[SHELL_ID] .g-recaptcha {\r\n	min-height: 60px;\r\n}\r\n\r\n#[SHELL_ID] [type=\"submit\"] {\r\n  	margin-top: 40px !important;\r\n	width: 150px !important;\r\n  	font-size: 24px;\r\n  	text-transform: capitalize !important;\r\n  	border-radius: 25px !important;\r\n  	float: right;\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'tea-time.png'),
				'bjl17b' => array('unique_id' => 'bjl17b','label' => 'Opacity Grey','active' => '1','original_id' => '0','params' => '97|58|52|58|123|115|58|51|58|34|116|112|108|34|59|97|58|50|48|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|102|102|102|102|102|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|101|102|54|49|54|49|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|100|100|51|51|51|51|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|54|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|104|116|109|108|100|101|108|105|109|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|50|50|53|58|34|60|100|105|118|32|99|108|97|115|115|61|92|34|112|97|112|101|114|45|112|108|97|110|101|92|34|62|60|105|109|103|32|115|114|99|61|92|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|112|97|112|101|114|45|112|108|97|110|101|46|112|110|103|92|34|32|62|60|47|100|105|118|62|13|10|60|100|105|118|32|99|108|97|115|115|61|92|34|102|97|32|102|97|45|112|97|112|101|114|45|112|108|97|110|101|45|111|92|34|62|60|47|100|105|118|62|13|10|60|104|51|62|67|111|110|116|97|99|116|32|85|115|60|47|104|51|62|13|10|60|112|62|68|111|110|92|39|116|32|104|101|115|105|116|97|116|101|32|116|111|32|99|111|110|116|97|99|116|32|117|115|44|32|119|101|92|39|108|108|32|97|110|115|119|101|114|32|121|111|117|32|97|110|121|116|105|109|101|32|115|111|111|110|33|60|47|112|62|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|52|58|34|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|48|58|34|102|105|114|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|50|58|34|80|104|111|110|101|32|78|117|109|98|101|114|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|112|104|111|110|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\n[fields]\n[form_end]','css' => '@import url(\'https://fonts.googleapis.com/css?family=Raleway\'); \r\n\r\n#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_0]\", 0.85)}};\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n  	color: #FFF;\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] h3, #[SHELL_ID] p {\r\n  	margin: 10px 0;\r\n  	text-align: center;\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID] .paper-plane {\r\n  	margin-top: 20px;\r\n  	height: 32px;\r\n  	text-align: center;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[else]\r\n  	border: 1px solid transparent;\r\n  	border-bottom-color: #FFF;\r\n  	background: transparent;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	color: #FFF;\r\n  	font-family: Raleway, sans-serif !important;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n  	outline: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n  	/* text-transform: capitalize;/**/\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	color: [bg_color_2];\r\n  	background-color: #FFF;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'opacity-grey.png'),
				'bjl17a' => array('unique_id' => 'bjl17a','label' => 'Spearmint','active' => '1','original_id' => '0','params' => '97|58|52|58|123|115|58|51|58|34|116|112|108|34|59|97|58|50|48|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|102|102|102|102|102|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|57|57|57|57|57|57|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|48|53|102|99|98|50|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|49|101|55|51|98|101|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|53|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|52|58|34|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|48|58|34|102|105|114|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|50|58|34|80|104|111|110|101|32|78|117|109|98|101|114|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\n[fields]\n[form_end]','css' => '@import url(\'https://fonts.googleapis.com/css?family=Kaushan+Script\'); \r\n\r\n#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 14px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n    color: {{adjust_opacity(\"[bg_color_1]\", 1)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 2px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	box-shadow: rgba(0, 0, 0, 0.0980392) 0px 4px 0px 0px inset;\r\n  	width: 150px;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'light-grey.png'),
				'bjl17c' => array('unique_id' => 'bjl17c','label' => 'Support Service','active' => '1','original_id' => '0','params' => '97|58|52|58|123|115|58|51|58|34|116|112|108|34|59|97|58|50|48|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|52|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|50|58|34|112|120|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|101|102|102|49|102|54|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|54|54|54|48|53|57|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|50|102|53|97|55|56|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|51|58|34|105|109|103|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|52|50|58|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|98|103|47|98|103|95|115|117|112|112|111|114|116|95|102|111|114|109|46|106|112|103|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|54|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|104|116|109|108|100|101|108|105|109|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|57|51|54|58|34|60|100|105|118|32|99|108|97|115|115|61|92|34|97|98|111|117|116|92|34|62|13|10|32|32|32|32|60|105|109|103|32|115|114|99|61|92|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|115|117|112|112|111|114|116|95|105|109|97|103|101|46|112|110|103|92|34|32|47|62|13|10|32|32|32|32|60|100|105|118|62|13|10|32|32|32|32|32|32|32|32|32|60|112|32|99|108|97|115|115|61|92|34|110|97|109|101|92|34|62|74|111|104|110|32|83|110|111|119|60|47|112|62|13|10|32|32|32|32|32|32|32|32|32|60|112|32|99|108|97|115|115|61|92|34|114|111|108|101|92|34|62|67|108|105|101|110|116|32|83|101|114|118|105|99|101|60|47|112|62|13|10|32|32|32|32|32|32|32|32|32|60|112|32|99|108|97|115|115|61|92|34|115|111|99|95|105|99|111|110|115|92|34|62|13|10|32|32|32|32|32|32|32|32|32|32|32|32|32|60|97|32|104|114|101|102|61|92|34|104|116|116|112|115|58|47|47|119|119|119|46|102|97|99|101|98|111|111|107|46|99|111|109|47|115|117|112|115|121|115|116|105|99|47|92|34|32|116|97|114|103|101|116|61|92|34|95|98|108|97|110|107|92|34|32|99|108|97|115|115|61|92|34|102|98|92|34|62|60|105|109|103|32|115|114|99|61|92|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|102|97|99|101|98|111|111|107|45|105|99|111|110|46|112|110|103|92|34|32|47|62|60|47|97|62|13|10|32|32|32|32|32|32|32|32|32|32|32|32|32|60|97|32|104|114|101|102|61|92|34|104|116|116|112|115|58|47|47|116|119|105|116|116|101|114|46|99|111|109|47|115|117|112|115|121|115|116|105|99|92|34|32|116|97|114|103|101|116|61|92|34|95|98|108|97|110|107|92|34|32|99|108|97|115|115|61|92|34|116|119|92|34|62|60|105|109|103|32|115|114|99|61|92|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|116|119|105|116|116|101|114|45|105|99|111|110|46|112|110|103|92|34|32|47|62|60|47|97|62|13|10|32|32|32|32|32|32|32|32|32|32|32|32|32|60|97|32|104|114|101|102|61|92|34|104|116|116|112|115|58|47|47|112|108|117|115|46|103|111|111|103|108|101|46|99|111|109|47|117|47|48|47|49|48|51|48|56|52|48|53|51|50|52|48|49|57|54|52|54|55|52|53|56|47|112|111|115|116|115|92|34|32|116|97|114|103|101|116|61|92|34|95|98|108|97|110|107|92|34|32|99|108|97|115|115|61|92|34|103|45|112|108|117|115|92|34|62|60|105|109|103|32|115|114|99|61|92|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|103|111|111|103|108|101|45|112|108|117|115|45|105|99|111|110|46|112|110|103|92|34|32|47|62|60|47|97|62|13|10|32|32|32|32|32|32|32|32|60|47|112|62|13|10|32|32|32|32|60|47|100|105|118|62|13|10|60|47|100|105|118|62|13|10|60|112|32|99|108|97|115|115|61|92|34|100|101|115|99|114|105|112|116|105|111|110|92|34|62|70|101|101|108|32|102|114|101|101|32|116|111|32|99|111|110|116|97|99|116|32|117|115|32|97|110|100|32|100|111|110|226|128|153|116|32|119|111|114|114|121|44|32|101|118|101|114|121|116|104|105|110|103|32|103|111|110|110|97|32|98|101|32|111|107|46|32|89|111|117|32|99|97|110|32|97|108|115|111|32|103|101|116|32|105|110|32|116|111|117|99|104|32|119|105|116|104|32|117|115|32|111|110|32|116|104|101|32|115|111|99|105|97|108|32|110|101|116|119|111|114|107|115|32|121|111|117|32|99|97|110|32|102|105|110|100|32|97|98|111|118|101|32|116|104|105|115|32|109|101|115|115|97|103|101|46|60|47|112|62|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|56|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|56|58|34|81|117|101|115|116|105|111|110|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|115|101|108|101|99|116|98|111|120|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|56|58|34|113|117|101|115|116|105|111|110|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|115|58|55|58|34|111|112|116|105|111|110|115|34|59|97|58|54|58|123|105|58|48|59|97|58|50|58|123|115|58|52|58|34|110|97|109|101|34|59|115|58|49|58|34|49|34|59|115|58|53|58|34|108|97|98|101|108|34|59|115|58|56|58|34|81|117|101|115|116|105|111|110|34|59|125|105|58|49|59|97|58|50|58|123|115|58|52|58|34|110|97|109|101|34|59|115|58|49|58|34|50|34|59|115|58|53|58|34|108|97|98|101|108|34|59|115|58|55|58|34|80|114|111|98|108|101|109|34|59|125|105|58|50|59|97|58|50|58|123|115|58|52|58|34|110|97|109|101|34|59|115|58|49|58|34|51|34|59|115|58|53|58|34|108|97|98|101|108|34|59|115|58|49|48|58|34|83|117|103|103|101|115|116|105|111|110|34|59|125|105|58|51|59|97|58|50|58|123|115|58|52|58|34|110|97|109|101|34|59|115|58|49|58|34|52|34|59|115|58|53|58|34|108|97|98|101|108|34|59|115|58|49|49|58|34|80|97|114|116|110|101|114|115|104|105|112|34|59|125|105|58|52|59|97|58|50|58|123|115|58|52|58|34|110|97|109|101|34|59|115|58|49|58|34|53|34|59|115|58|53|58|34|108|97|98|101|108|34|59|115|58|51|48|58|34|82|101|113|117|101|115|116|32|102|111|114|32|67|117|115|116|111|109|32|68|101|118|101|108|111|112|109|101|110|116|34|59|125|105|58|53|59|97|58|50|58|123|115|58|52|58|34|110|97|109|101|34|59|115|58|49|58|34|54|34|59|115|58|53|58|34|108|97|98|101|108|34|59|115|58|53|58|34|79|116|104|101|114|34|59|125|125|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|52|58|34|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|51|58|34|69|109|97|105|108|32|65|100|100|114|101|115|115|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|56|58|34|69|110|116|101|114|32|121|111|117|114|32|109|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\n[fields]\n[form_end]','css' => '#[SHELL_ID] {\r\n  	[if bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[elseif bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	[else]\r\n  	background-color: #FFF;\r\n  	[endif]\r\n  	font-family: sans-serif;\r\n  	padding: 20px;\r\n  	width: 380px;\r\n}\r\n\r\n#[SHELL_ID] .about,\r\n#[SHELL_ID] p {\r\n  	margin: 0;\r\n	text-align: center;\r\n  	color: #FFF;\r\n  	font-size: 14px;\r\n  	line-height: 1em;\r\n}\r\n\r\n#[SHELL_ID] .cfsFieldShell {\r\n	position: relative;\r\n}\r\n\r\n#[SHELL_ID] .cfsFieldShell select {\r\n	position: absolute;\r\n  	padding-left: 5px;\r\n  	top: 0;\r\n  	left: 0;\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	box-sizing: border-box;\r\n  	font-family: sans-serif;\r\n  	font-size: 12px;\r\n  	color: #666059;\r\n}\r\n\r\n#[SHELL_ID] p.description {\r\n  	line-height: 18px;\r\n}\r\n\r\n#[SHELL_ID] .about div {\r\n	height: 100px;\r\n  	margin-bottom: 20px;\r\n  	margin-right: 40px;\r\n}\r\n\r\n#[SHELL_ID] div .name {\r\n	font-size: 30px;\r\n  	line-height: 1.8em;\r\n}\r\n\r\n#[SHELL_ID] div .role {\r\n    margin-top: -5px;\r\n}\r\n\r\n#[SHELL_ID] .about > img {\r\n  	width: 100px;\r\n  	height: 100px;\r\n  	margin-right: 20px;\r\n  	margin-bottom: 20px;\r\n  	float: left;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons {\r\n  	margin-top: 17px;\r\n	margin-left: 120px;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons a {\r\n  	font-size: 0;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons a + a {\r\n  	padding-left: 3px;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons img {\r\n  	display: inline-block;\r\n	height: 16px;\r\n  	width: 16px;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons img:hover {\r\n  	opacity: 0.5;\r\n}\r\n\r\n\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck,\r\n#[SHELL_ID] button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n  	[if bg_type_2 == \'color\']\r\n	border: 1px solid {{adjust_opacity(\"[bg_color_2]\", 0.5)}};\r\n  	[endif]\r\n  	[if bg_type_0 == \'color\']\r\n	background-color: [bg_color_0];\r\n  	[endif]\r\n  	[if bg_type_1 == \'color\']\r\n	color: [bg_color_1];\r\n  	[endif]  \r\n    hyphens: none;\r\n    border-radius: 3px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] input:focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n    outline: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	width: 50%;\r\n  	float: right;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n}','sort_order' => '0','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'kiwifruit.png'),
			);
		}
		foreach($data as $uid => $d) {
			self::installDataByUid('@__forms', $uid, $d);
		}
	}
	static public function installDataByUid($tbl, $uid, $data) {
		$id = (int) dbCfs::get("SELECT id FROM $tbl WHERE unique_id = '$uid' AND original_id = 0", 'one');
		$action = $id ? 'UPDATE' : 'INSERT INTO';
		$values = array();
		foreach($data as $k => $v) {
			$values[] = "$k = \"$v\"";
		}
		$valuesStr = implode(',', $values);
		$query = "$action $tbl SET $valuesStr";
		if($action == 'UPDATE')
			$query .= " WHERE unique_id = '$uid' AND original_id = 0";
		if(dbCfs::query($query)) {
			return $action == 'UPDATE' ? $id : dbCfs::insertID();
		}
		return false;
	}
}
