/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global) {'use strict';

	/**
	 * Copyright (C) 2014-2016 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var Query = __webpack_require__(6),
	    FindReplace = __webpack_require__(7),
	    Report = __webpack_require__(1),
	    Feedback = __webpack_require__(2),
	    Util = __webpack_require__(3),
	    Deprecated = __webpack_require__(8),
	    Export = __webpack_require__(10);

	jQuery(document).ready(function ($) {
		'use strict';

		var model = new Export();

		// Export to file
		$('#ai1wm-export-file').click(function (e) {
			var storage = Util.random(12);
			var options = Util.form('#ai1wm-export-form').concat({ name: 'storage', value: storage });

			// Set global params
			model.setParams(options);

			// Start export
			model.start();

			e.preventDefault();
		});

		$('.ai1wm-accordion > .ai1wm-title').click(function () {
			$(this).parent().toggleClass('ai1wm-active');
		});

		$('#ai1wm-add-new-replace-button').ai1wm_find_replace();

		$('.ai1wm-expandable > p:first, .ai1wm-expandable > h4:first, .ai1wm-expandable > div.ai1wm-button-main').on('click', function () {
			$(this).parent().toggleClass('ai1wm-open');
		});

		$('.ai1wm-collapsable').ai1wm_query();
	});

	global.Ai1wm = { Util: Util, Export: Export };
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ },
/* 1 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2016 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	jQuery(document).ready(function ($) {
		'use strict';

		$('#ai1wm-report-problem-button').click(function (e) {
			$(this).next('.ai1wm-report-problem-dialog').toggleClass('ai1wm-report-active');

			e.preventDefault();
		});

		$('#ai1wm-report-cancel').click(function (e) {
			$(this).closest('.ai1wm-report-problem-dialog').removeClass('ai1wm-report-active');

			e.preventDefault();
		});

		$('#ai1wm-report-submit').click(function () {
			var email = $('.ai1wm-report-email').val();
			var message = $('.ai1wm-report-message').val();
			var terms = $('.ai1wm-report-terms').is(':checked');

			$.ajax({
				type: 'POST',
				url: ai1wm_report.ajax.url,
				data: { 'ai1wm-email': email, 'ai1wm-message': message, 'ai1wm-terms': +terms },
				success: function success(data) {
					var errors = data.errors;
					if (errors.length > 0) {
						// Reset previous messages
						$('.ai1wm-report-problem-dialog .ai1wm-message').remove();

						var content = $('<div />').addClass('ai1wm-message ai1wm-error-message');
						$.each(errors, function (key, value) {
							content.append('<p>' + value + '</p>');
						});

						$('.ai1wm-report-problem-dialog').prepend(content);
					} else {
						var _content = $('<div />').addClass('ai1wm-message ai1wm-success-message').append('<p>Thanks for submitting your request!</p>');
						$('.ai1wm-report-problem-dialog').html(_content);

						// Hide message
						setTimeout(function () {
							$('.ai1wm-report-problem-dialog').removeClass('ai1wm-report-active');
						}, 2000);
					}
				},
				dataType: 'json',
				async: false
			});
		});
	});

/***/ },
/* 2 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2016 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	jQuery(document).ready(function ($) {
		'use strict';

		// Reset feedback form

		$('.ai1wm-feedback-type').attr('checked', false);

		// Review
		$('#ai1wm-feedback-type-link-1').click(function (e) {
			var radio = $('#ai1wm-feedback-type-1');
			if (radio.is(':checked')) {
				radio.attr('checked', false);
				e.preventDefault();
			} else {
				radio.attr('checked', true);
			}
		});

		// Improvement
		$('#ai1wm-feedback-type-2').click(function () {
			// Hide other options
			$('#ai1wm-feedback-type-1, #ai1wm-feedback-type-3').closest('li').hide();

			// change placeholder message
			$('.ai1wm-feedback-form').find('.ai1wm-feedback-message').attr('placeholder', 'Leave plugin developers any feedback here');

			// Show feedback form
			$('.ai1wm-feedback-form').fadeIn();
		});

		// Help
		$('#ai1wm-feedback-type-3').click(function () {
			// Hide other options
			$('#ai1wm-feedback-type-1, #ai1wm-feedback-type-2').closest('li').hide();

			// change placeholder message
			$('.ai1wm-feedback-form').find('.ai1wm-feedback-message').attr('placeholder', 'How may we help you?');

			// Show feedback form
			$('.ai1wm-feedback-form').fadeIn();
		});

		// Cancel feedback form
		$('#ai1wm-feedback-cancel').click(function (e) {
			$('.ai1wm-feedback-form').fadeOut(function () {
				$('.ai1wm-feedback-type').attr('checked', false).closest('li').show();
			});
			e.preventDefault();
		});

		// Send feedback form
		$('#ai1wm-feedback-submit').click(function () {
			var type = $('.ai1wm-feedback-type:checked').val();
			var email = $('.ai1wm-feedback-email').val();
			var message = $('.ai1wm-feedback-message').val();
			var terms = $('.ai1wm-feedback-terms').is(':checked');

			$.ajax({
				type: 'POST',
				url: ai1wm_feedback.ajax.url,
				data: { 'ai1wm-type': type, 'ai1wm-email': email, 'ai1wm-message': message, 'ai1wm-terms': +terms },
				success: function success(data) {
					var errors = data.errors;
					if (errors.length > 0) {
						// Reset previous messages
						$('.ai1wm-feedback .ai1wm-message').remove();

						var content = $('<div />').addClass('ai1wm-message ai1wm-error-message');
						$.each(errors, function (key, value) {
							content.append('<p>' + value + '</p>');
						});

						$('.ai1wm-feedback').prepend(content);
					} else {
						var _content = $('<div />').addClass('ai1wm-message ai1wm-success-message').append('<p>Thanks for submitting your feedback!</p>');
						$('.ai1wm-feedback').html(_content);
					}
				},
				dataType: 'json',
				async: false
			});
		});
	});

/***/ },
/* 3 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2016 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var $ = jQuery;

	module.exports = {
		random: function random(len) {
			var text = '';
			var possible = 'abcdefghijklmnopqrstuvwxyz0123456789';

			for (var i = 0; i < len; i++) {
				text += possible.charAt(Math.floor(Math.random() * possible.length));
			}

			return text;
		},
		form: function form(id) {
			return $(id).serializeArray();
		},
		ucfirst: function ucfirst(text) {
			return text.charAt(0).toUpperCase() + text.slice(1);
		},
		list: function list(input) {
			// Convert object to list
			if ($.isPlainObject(input)) {
				var result = [];
				var params = decodeURIComponent($.param(input)).split('&');

				// Loop over params
				$.each(params, function (index, item) {
					var value = item.split('=');

					// Add item
					result.push({ name: value[0], value: value[1] });
				});

				return result;
			}

			return input;
		}
	};

/***/ },
/* 4 */,
/* 5 */,
/* 6 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2016 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	;(function ($) {

	  $.fn.ai1wm_query = function () {
	    var findInput = $(this).find('input.ai1wm-query-find-input'),
	        replaceInput = $(this).find('input.ai1wm-query-replace-input'),
	        findText = $(this).find('small.ai1wm-query-find-text'),
	        replaceText = $(this).find('small.ai1wm-query-replace-text');

	    findInput.on('change paste input keypress keydown keyup', function () {
	      var _inputValue = $(this).val().length > 0 ? $(this).val() : '<text>';
	      findText.text(_inputValue);
	    });

	    replaceInput.on('change paste input keypress keydown keyup', function () {
	      var _inputValue = $(this).val().length > 0 ? $(this).val() : '<another-text>';
	      replaceText.text(_inputValue);
	    });
	    return this;
	  };
	})(jQuery);

/***/ },
/* 7 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2016 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	;(function ($) {

	  $.fn.ai1wm_find_replace = function () {
	    $(this).click(function (e) {
	      e.preventDefault();

	      var row = $('#ai1wm-queries > li:first').clone();

	      // Reset input values
	      row.find('input').val('');

	      // Reset ai1wm-query-find-text
	      row.find('.ai1wm-query-find-text').html('&lt;text&gt;');

	      // Reset ai1wm-query-replace-text
	      row.find('.ai1wm-query-replace-text').html('&lt;another-text&gt;');

	      $('#ai1wm-queries > li').removeClass('ai1wm-open');

	      $(row).addClass('ai1wm-open');

	      // Add new replace fields
	      $('#ai1wm-queries').append(row);
	      $(row).ai1wm_query();
	      $(row).find('p:first').on('click', function () {
	        $(this).parent().toggleClass('ai1wm-open');
	      });
	    });

	    return this;
	  };
	})(jQuery);

/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	/**
	 * Copyright (C) 2014-2016 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var Util = __webpack_require__(3),
	    Dialog = __webpack_require__(9);

	var Extensions = {
	  's3': 'Amazon S3 Extension',
	  'url': 'URL Extension',
	  'ftp': 'FTP Extension',
	  'gdrive': 'Google Drive Extension',
	  'dropbox': 'Dropbox Extension'
	};

	window.Ai1wmExportController = function (provider) {
	  this._export = {};
	  this._provider = provider;
	};

	window.Ai1wmExportController.prototype.start = function () {
	  new Dialog('<strong>All in One WP Migration</strong> is not compatible with current version of ' + '<strong>' + Extensions[this._provider] + '</strong>. Please contact ' + '<a href="mailto:support@servmask.com">support@servmask.com</a> for more details.');
	};

	window.Ai1wmImportController = function (provider) {
	  this._import = {};
	  this._provider = provider;
	};

	window.Ai1wmImportController.prototype.init = function () {};

	window.Ai1wmImportController.prototype.download = function () {
	  new Dialog('<strong>All in One WP Migration</strong> is not compatible with current version of ' + '<strong>' + Extensions[this._provider] + '</strong>. Please contact ' + '<a href="mailto:support@servmask.com">support@servmask.com</a> for more details.');
	};

/***/ },
/* 9 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2016 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var $ = jQuery;

	var Dialog = function Dialog(text) {
		var self = this;

		// Create the overlay
		this.overlay = $('<div class="ai1wm-overlay"></div>');

		// Create the modal container
		this.container = $('<div></div>');

		// Create the modal container
		this.modal = $('<div class="ai1wm-modal-container"></div>');

		// Create section to hold title, message and action
		this.section = $('<section></section>');

		// Create paragraph to hold mesage
		this.message = $('<p></p>').addClass('ai1wm-dialog-message').html(text);

		// Create action section
		this.action = $('<div></div>');

		// Create close button
		this.closeButton = $('<button class="ai1wm-button-red">Close</button>').on('click', function () {
			self.modal.hide();
			self.overlay.hide();
		});

		// Append close button
		this.action.append(this.closeButton);

		// Append message to section
		this.section.append(this.message);

		// Append section and action to container
		this.container.append(this.section).append(this.action);

		// Render modal
		this.modal.html(this.container).show();
		this.overlay.show();

		$('body').append(this.overlay).append(this.modal);
	};

	module.exports = Dialog;

/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	/**
	 * Copyright (C) 2014-2016 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var Util = __webpack_require__(3),
	    Modal = __webpack_require__(11),
	    $ = jQuery;

	var Export = function Export() {
		var self = this;

		// Set params
		this.params = [];

		// Set modal
		this.modal = new Modal();

		// Set stop listener
		this.modal.onStop = function (options) {
			self.onStop(options);
		};
	};

	Export.prototype.setParams = function (params) {
		this.params = Util.list(params);
	};

	Export.prototype.start = function (options) {
		var self = this;

		// Initializing beforeunload event
		$(window).bind('beforeunload', function () {
			return 'You are about to stop exporting your website, are you sure?';
		});

		// Set stop
		this.stop = false;

		// Set initial status
		this.setStatus({ type: 'info', message: 'Preparing to export...' });

		// Set params
		var params = this.params.concat({ name: 'secret_key', value: ai1wm_export.secret_key });

		// Set additional params
		if (options) {
			params = params.concat(Util.list(options));
		}

		// Export
		$.post(ai1wm_export.ajax.url, params).done(function () {
			self.getStatus();
		}).fail(function () {
			self.setStatus({
				type: 'error',
				message: 'Unable to start the export. Refresh the page and try again'
			});
		});
	};

	Export.prototype.clean = function (options) {
		var self = this;

		// Set stop
		this.stop = true;

		// Set params
		var params = this.params.concat({ name: 'secret_key', value: ai1wm_export.secret_key }).concat({ name: 'priority', value: 300 });

		// Set additional params
		if (options) {
			params = params.concat(Util.list(options));
		}

		// Clean
		$.post(ai1wm_export.ajax.url, params).done(function () {
			// Unbinding the beforeunload event when we stop exporting
			$(window).unbind('beforeunload');
		}).fail(function () {
			self.setStatus({
				type: 'error',
				message: 'Unable to clean the export. Refresh the page and try again'
			});
		});
	};

	Export.prototype.getStatus = function () {
		var self = this;

		// Stop getting status
		if (this.stop) {
			return;
		}

		$.ajax({
			cache: false,
			url: ai1wm_export.status.url,
			dataType: 'json'
		}).done(function (params) {
			if (params) {
				self.setStatus(params);

				// Next status
				switch (params.type) {
					case 'done':
					case 'error':
					case 'download':
						// Unbinding beforeunload event when any case is performed
						$(window).unbind('beforeunload');
						return;
				}
			}

			// Export is not done yet, let's check status in 3 seconds
			setTimeout(function () {
				self.getStatus();
			}, 3000);
		}).fail(function () {
			// Export is not done yet, let's check status in 3 seconds
			setTimeout(function () {
				self.getStatus();
			}, 3000);
		});
	};

	Export.prototype.setStatus = function (params) {
		this.modal.render(params);
	};

	Export.prototype.onStop = function (options) {
		this.clean(options);
	};

	module.exports = Export;

/***/ },
/* 11 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Copyright (C) 2014-2016 ServMask Inc.
	 *
	 * This program is free software: you can redistribute it and/or modify
	 * it under the terms of the GNU General Public License as published by
	 * the Free Software Foundation, either version 3 of the License, or
	 * (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
	 *
	 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
	 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
	 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
	 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
	 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
	 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
	 */

	var $ = jQuery;

	var Modal = function Modal() {
		var self = this;

		// Error Modal
		this.error = function (params) {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold title
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create title
			var title = $('<span></span>').addClass('ai1wm-title-red').text('Unable to export');

			// Create close button
			var closeButton = $('<button class="ai1wm-button-red">Close</button>').on('click', function () {
				self.modal.hide();
				self.overlay.hide();
			});

			// Append close button
			action.append(closeButton);

			// Append title to section
			header.append(title);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Info Modal
		this.info = function (params) {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold loader
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create loader
			var loader = $('<span class="ai1wm-loader"></span>');

			// Create stop export
			var stopButton = $('<button class="ai1wm-button-red"><i class="ai1wm-icon-notification"></i> Stop export</button>').on('click', function () {
				$(this).attr('disabled', 'disabled');
				self.onStop();
				self.modal.hide();
				self.overlay.hide();
			});

			// Append stop button
			action.append(stopButton);

			// Append loader to header
			header.append(loader);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Done Modal
		this.done = function (params) {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold title
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create title
			var title = $('<span></span>').addClass('ai1wm-title-green').text(params.title);

			// Create close button
			var closeButton = $('<button class="ai1wm-button-red">Close</button>').on('click', function () {
				self.modal.hide();
				self.overlay.hide();
			});

			// Append close button
			action.append(closeButton);

			// Append title to section
			header.append(title);

			// Append header and message to section
			section.append(header).append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Download Modal
		this.download = function (params) {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold title
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>').html(params.message);

			// Create action section
			var action = $('<div></div>');

			// Create close button
			var closeButton = $('<button class="ai1wm-button-red">Close</button>').on('click', function () {
				self.modal.hide();
				self.overlay.hide();
			});

			// Append close button
			action.append(closeButton);

			// Append message to section
			section.append(message);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		};

		// Create the overlay
		this.overlay = $('<div class="ai1wm-overlay"></div>');

		// Create the modal container
		this.modal = $('<div class="ai1wm-modal-container"></div>');

		$('body').append(this.overlay) // Append overlay to body
		.append(this.modal); // Append modal to body
	};

	Modal.prototype.render = function (params) {

		// Show modal
		switch (params.type) {
			case 'error':
				this.error(params);
				break;

			case 'info':
				this.info(params);
				break;

			case 'done':
				this.done(params);
				break;

			case 'download':
				this.download(params);
				break;
		}
	};

	module.exports = Modal;

/***/ }
/******/ ]);